(function(){
  const KEYWORDS = [
    'abstract','assert','boolean','break','byte','case','catch','char','class','const','continue',
    'default','do','double','else','enum','extends','final','finally','float','for','goto',
    'if','implements','import','instanceof','int','interface','long','native','new','package',
    'private','protected','public','return','short','static','strictfp','super','switch',
    'synchronized','this','throw','throws','transient','try','void','volatile','while',
    'true','false','null'
  ];

  function escapeHtml(text) {
    return text
      .replace(/&/g, '&amp;')
      .replace(/</g, '&lt;')
      .replace(/>/g, '&gt;')
      .replace(/"/g, '&quot;')
      .replace(/'/g, '&#39;');
  }

  function classifyToken(token) {
    if (token.startsWith('/*') || token.startsWith('//')) {
      return 'javadoc-comment';
    }
    if (token.startsWith('"') || token.startsWith("'")) {
      return 'javadoc-string';
    }
    return 'javadoc-keyword';
  }

  function highlightJava(text) {
    const keywordPattern = KEYWORDS.join('|');
    const tokenPattern = new RegExp(
      '(\\/\\*[\\s\\S]*?\\*\\/|\\/\\/[^\\n]*|"(?:\\\\.|[^"\\\\])*"|\'(?:\\\\.|[^\'\\\\])*\'|\\b(?:' + keywordPattern + ')\\b)',
      'g'
    );

    let result = '';
    let lastIndex = 0;
    let match;
    while ((match = tokenPattern.exec(text)) !== null) {
      const token = match[0];
      result += escapeHtml(text.slice(lastIndex, match.index));
      const tokenClass = classifyToken(token);
      result += '<span class="' + tokenClass + '">' + escapeHtml(token) + '</span>';
      lastIndex = match.index + token.length;
    }
    result += escapeHtml(text.slice(lastIndex));
    return result;
  }

  function highlightElement(element) {
    const text = element.textContent || '';
    element.innerHTML = highlightJava(text);
  }

  window.Cn1JavaDocHighlight = {
    highlightElement
  };
})();
